/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root

    default property alias content: roundedContainer.data

    Rectangle {
        id: roundedContainer

        anchors.fill: parent
        color: Theme.rgba(Theme.highlightColor, 0.2)
        visible: false
        layer.enabled: true
    }

    Rectangle {
        anchors.fill: parent
        radius: parent.width * 0.5
        color: Theme.primaryColor
        visible: true
        layer.enabled: visible
        layer.samplerName: "maskSource"
        layer.effect: ShaderEffect {
            property var colorSource: roundedContainer
            fragmentShader: "
                uniform lowp sampler2D colorSource;
                uniform lowp sampler2D maskSource;
                uniform lowp float qt_Opacity;
                varying highp vec2 qt_TexCoord0;
                void main() {
                    gl_FragColor =
                        texture2D(colorSource, qt_TexCoord0)
                        * texture2D(maskSource, qt_TexCoord0).a
                        * qt_Opacity;
                }
            "
        }
    }
}
