/**
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import ru.omp.authclient 1.0

Item {
    property string graphicIllustration: "graphic-locked-illustration.svg"

    function resultMessage(id) {
		switch (id) {
        case AuthUiClient.Success:
            //% "Success"
            return qsTrId("auth-client-er-success")
        case AuthUiClient.AuthServiceUnavailable:
            //% "Authentication Service Unavailable"
            return qsTrId("auth-client-er-auth-service-unavailable")
        case AuthUiClient.MethodPageUnavailable:
            //% "Method Page Unavailable"
            return qsTrId("auth-client-er-method-page-unavailable")
        case AuthUiClient.NoAuthUi:
            //% "No AuthUi registered"
            return qsTrId("auth-client-er-no-authui-registered")
        case AuthUiClient.InternalError:
            //% "Internal Error"
            return qsTrId("auth-client-er-internal-error")
        case AuthUiClient.EncryptedDeviceUnlocked:
            //% "Encrypted Device Unlocked"
            return qsTrId("auth-client-er-encrypted-device-unlocked")
        case AuthUiClient.EncryptedDeviceUnlockFailed:
            //% "Encrypted Device Unlock Failed"
            return qsTrId("auth-client-er-encrypted-device-unlock-failed")
        case AuthUiClient.EncryptedDeviceCannotUpdatePassword:
            //% "Encrypted Device Cannot Update Password"
            return qsTrId("auth-client-er-encrypted-device-cannot-update-password")
        case AuthUiClient.CannotUnlockEncryptedDevice:
            //% "Cannot unlock encrypted device"
            return qsTrId("auth-client-er-cannot-unlock-encrypted-device")
        case AuthUiClient.Incognito:
            //% An error occurred at one of the authentication stages
            return qsTrId("auth-client-er-authentication-failed")
        default:
            //% "Unknown error"
            return qsTrId("auth-client-er-unknown-error")
        }
    }

    function errorMessage(id) {
        switch (id) {
        case AuthUiClient.Success:
            //% "Success"
            return qsTrId("auth-client-er-success")
        default:
            //% "Try again"
            return qsTrId("auth-loginrestriction-er-ry-again")
        }
    }
}
