/**
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.authclient 1.0

Item {
    id: root

    property var handleAuthenticated
    property var handleAuthFailed
    property var handleAuthDataChanged
    property var token: new ArrayBuffer()
    property var cachedToken: new ArrayBuffer()
    property bool tokenIsValid: false
    property var authClient
    property bool authenticated: tokenIsValid && authClient.authenticated
    property var _challenge: null

    signal authDropped()

    function doAuth() {
        root.authClient.authenticate("settings", root._challenge !== null ? {"challenge" : root._challenge} : {})
    }

    function authenticate(onAuthenticated, onAuthFailed, challenge) {
        if (authenticated) {
            onAuthenticated()
        } else {
            root._challenge = challenge === undefined ? null : challenge
            root.handleAuthenticated = onAuthenticated
            root.handleAuthFailed = onAuthFailed
            doAuth()
        }
    }

    function changeAuthData(factorName, params, onChanged) {
        root.handleAuthDataChanged = onChanged
        root.authClient.changeAuthData(factorName, params)
    }

    Connections {
        target: authClient

        onAuthenticatedChanged: {
            if (root.authClient.authenticated) {
                token = authToken
                tokenIsValid = true

                if (root.handleAuthenticated !== undefined) {
                    root.handleAuthenticated()
                }
            } else {
                if (root.handleAuthFailed !== undefined) {
                    root.handleAuthFailed()
                }
            }

            // reset handlers
            root.handleAuthenticated = undefined
            root.handleAuthFailed = undefined
        }

        onAuthDataChanged: {
            if (root.handleAuthDataChanged === undefined) {
                return
            }
            root.handleAuthDataChanged()
            root.handleAuthDataChanged = undefined
        }

        onChangeAuthDataFailed: root.handleAuthDataChanged = undefined

        onDiscredit: {
            root.handleAuthenticated = undefined
            if (root.handleAuthFailed !== undefined) {
                root.handleAuthFailed()
                root.handleAuthFailed = undefined
            }
        }
    }
}
