/**
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import ru.omp.auth.sudis 1.0

Item {
    id: root

    property alias settings: settingsSudis
    property alias uid: settingsSudis.uid

    function infoMessage(id) {
        switch (id) {
        case SettingsSudis.Connecting:
            //% "Connecting to sudis...  Wait, please"
            return qsTrId("auth-sudis-la-connecting-wait-please")
        case SettingsSudis.EnterPasswordOrPin:
            //% "Enter password or pin"
            return qsTrId("auth-sudis-la-enter-password-or-pin")
        default:
            //% "Unknown input request"
            return qsTrId("auth-sudis-la-unknown-input-request")
        }
    }

    function resultMessage(id) {
        switch (id) {
        case SettingsSudis.Success:
            //% "Success"
            return qsTrId("auth-sudis-er-success")
        case SettingsSudis.BadPassword:
            //% "Wrong password"
            var message = qsTrId("auth-sudis-er-wrong-password")
            if (settings.maxAttempts > 0) {
                message += " (" + settings.currentAttempts + "/" + settings.maxAttempts + ")"
            }
            return message
        case SettingsSudis.CannotStartClient:
            //% "Cannot start Sudis client"
            return qsTrId("auth-sudis-er-cannot-start-client")
        case SettingsSudis.EncryptedPartitionLocked:
            //% "Encrypted partition locked"
            return qsTrId("auth-sudis-er-encrypted-partition-locked")
        case SettingsSudis.CannotConnectClient:
            //% "Cannot connect to Sudis client"
            return qsTrId("auth-sudis-er-cannot-connect-client")
        case SettingsSudis.CannotCommunicateClient:
            //% "Cannot communicate to Sudis client"
            return qsTrId("auth-sudis-er-cannot-communicate-client")
        case SettingsSudis.UserLocked:
            //% "User is locked. Ask administrator to help"
            return qsTrId("auth-sudis-er-user-locked")
        case SettingsSudis.TooManyAttempts:
            //% "Too many authentication attempts. User is locked, data is deleted"
            return qsTrId("auth-sudis-er-too-many-attempts")
        case SettingsSudis.TooManyAttemptsWithoutDeleted:
            //% "Too many authentication attempts. User is locked"
            return qsTrId("auth-sudis-er-too-many-attempts-without-deleted")
        case SettingsSudis.NoUsbDevice:
            //% "Authentication failed. No token"
            return qsTrId("auth-sudis-er-no-token")
        case SettingsSudis.ConnectionError:
            //% "Connection error"
            return qsTrId("auth-sudis-er-connection-error")
        case SettingsSudis.AuthFailed:
            //% "Authentication failed"
            var message = qsTrId("auth-sudis-er-auth-failed")
            if (settings.maxAttempts > 0) {
                message += " (" + settings.currentAttempts + "/" + settings.maxAttempts + ")"
            }
            return message
        case SettingsSudis.BadDefaultCert:
            //% "Authentication with default certificate is failed"
            return qsTrId("auth-sudis-er-bad-default-cert")
        case SettingsSudis.UserCannotUnlock:
            //% "User cannot unlock device, ask an administrator to set one-time password"
            return qsTrId("auth-sudis-er-user-cannot-unlock")
        case SettingsSudis.ErrAuthType:
            //% "Incorrect login type"
            return qsTrId("auth-sudis-er-auth-type")
        default:
            //% "Other error"
            return qsTrId("auth-sudis-er-other-error")
        }
    }

    SettingsSudis {
        id: settingsSudis
    }
}
