/**
 * SPDX-FileCopyrightText: Copyright 2022 - 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Column {
    id: keypad

    property bool upperCase
    property color textColor: Theme.primaryColor
    property real buttonWidth: Theme.itemSizeSmall
    property real buttonHeight: Theme.itemSizeSmall

    // This font avoids uncertainty with "I" and "l" characters
    property string monoFontFamily: "DejaVu Sans Mono"
    property string _fontFamily: upperCase ? monoFontFamily : Theme.fontFamily
    property real _horizontalSpacing: Theme.paddingSmall*0.5

    Repeater {
        model: [
            ['q','w','e','r','t','y','u','i','o','p'],
            ['a','s','d','f','g','h','j','k','l'],
            ['z','x','c','v','b','n','m']
        ]
        Row {
            anchors.horizontalCenter: parent.horizontalCenter
            spacing: _horizontalSpacing

            Repeater {
                model: modelData
                EmbeddedKeyboardButton {
                    width: buttonWidth
                    height: buttonHeight
                    fontFamily: _fontFamily
                    text: upperCase ? modelData.toUpperCase() : modelData
                    textColor: keypad.textColor
                }
            }
        }
    }
}

