/**
 * SPDX-FileCopyrightText: Copyright 2022 - 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Column {
    id: keypad

    property real buttonWidth: Theme.itemSizeSmall
    property real buttonHeight: Theme.itemSizeSmall
    property real _horizontalSpacing: Theme.paddingSmall*0.5

    Repeater {
        model: [
            { symbols: ['1','2','3','4','5','6','7','8','9','0'], color: Theme.primaryColor },
            { symbols: ['!','@','#','$','%','?','&','*','-','+'], color: Theme.secondaryHighlightColor },
            { symbols: ['(',')','=','<','>','^','_'], color: Theme.secondaryHighlightColor }
        ]

        Row {
            anchors.horizontalCenter: parent.horizontalCenter
            spacing: _horizontalSpacing

            Repeater {
                id: keyline
                
                property color color: modelData.color

                model: modelData.symbols
                EmbeddedKeyboardButton {
                    width: buttonWidth
                    height: buttonHeight
                    text: modelData
                    textColor: keyline.color
                }
            }
        }
    }
}


