/**
 * SPDX-FileCopyrightText: Copyright 2022 - 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

MouseArea {
    id: dialerButton

    property color backgroundColor: "transparent"
    property alias textColor: numberLabel.color
    property string fontFamily: Theme.fontFamily
    property real backgroundRadius: Theme.pixelRatio*12
    property int key
    property string text
    property bool down: pressed && containsMouse

    onClicked: dialer._buttonClicked(text)
    onPressed: dialer._buttonPressed(dialerButton, text)
    onReleased: dialer._buttonReleased(text)
    onCanceled: dialer._buttonCanceled(text)
    onPressAndHold: { mouse.accepted = false; dialer.pressAndHold(text, mouse) }

    Rectangle {
        id: backgroundButton

        anchors.fill: parent

        color: dialerButton.backgroundColor
        radius: dialerButton.backgroundRadius
    }

    Label {
        id: numberLabel
        
        anchors.centerIn: backgroundButton

        font.pixelSize: Theme.fontSizeLarge
        font.family: dialerButton.fontFamily
        text: dialerButton.text
    }
}
