/**
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Column {
    property real iconSize

    property bool _screenIsLarge: Screen.sizeCategory >= Screen.Large
    property real _sizePrimary: _screenIsLarge ? Theme.fontSizeExtraLarge
                                               : Theme.fontSizeLarge
    property real _sizeSecondary: _screenIsLarge ? Theme.fontSizeMedium
                                                 : Theme.fontSizeSmall

    opacity: root.showLabel ? 1 : 0

    function retranslate() {
        //% "MVD Russian"
        title.text = qsTrId("authd-method-sudis-he-mvd-russian")
        //% "Access control service"
        subtitle.text = qsTrId("authd-method-sudis-he-access-control-service")
    }

    Image {
        anchors.horizontalCenter: parent.horizontalCenter
        source: "mvd-logo.svg"
        sourceSize.height: iconSize
        sourceSize.width: iconSize * 1.8
    }

    Label {
        id: title

        width: parent.width
        wrapMode: Text.Wrap
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: _sizePrimary
        color: Theme.highlightColor
    }

    Label {
        id: subTitleText

        width: parent.width
        wrapMode: Text.Wrap
        horizontalAlignment: Text.AlignHCenter
        font.pixelSize: _sizeSecondary
        color: Theme.highlightColor
    }

    Component.onCompleted: retranslate()
}
