/**
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import ru.omp.auth.smartcard 1.0

Item {
    id: root

    property int uid
    property SettingsSmartCard settings: _settings

    function resultMessage(id) {
        switch (id) {
        case SettingsSmartCard.Success:
            //% "Success"
            return qsTrId("auth-smartcard-er-success")
        default:
            //% "Other error"
            return qsTrId("auth-smartcard-er-other-error")
        }
    }

    SettingsSmartCard {
        id: _settings

        uid: root.uid
    }
}
