/**
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.authclient 1.0
import ru.omp.auth.smartcard 1.0

BaseAuthPluginItem {
    id: root

    property AuthUiPart uiPart: authUi.mainPart
    property QtObject objPluginInfo: uiPart.info
    property SettingsSmartCard settingsSmartCard: objPluginInfo && objPluginInfo.settings ? objPluginInfo.settings : null
    property alias orientation: smartCard.orientation
    property bool invisibleBottomItem: !authUi.emergency && uiPart.state === SettingsSmartCard.BoundSmartCard

    signal clicked()

    function askAction(actionName) {
        authUi.setResponse({ "action": actionName })
    }

    onReset: smartCard.clear()

    ComponentSmartCard {
        id: smartCard

        anchors.fill: parent
        settingsSmartCard: objPluginInfo.settings

        onFindSmartCardSignal: askAction("FindSmartCard")
        onTryAgain: askAction("TryAgain")
        onUnlockSmartCardSignal: authUi.setResponse({ "pin": pin })
        onFinish: askAction("Finish")
    }
}
