/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Rectangle {
    id: root

    property string text

    anchors.horizontalCenter: parent.horizontalCenter
    width: parent.width - Theme.paddingLarge * 2
    height: Theme.dp(18) + Theme.paddingLarge + Math.max(mainLabel.height, icon.height)
    radius: Theme.paddingSmall
    color: Theme.rgba(Theme.highlightColor, Theme.opacityFaint)

    Image {
        id: icon

        anchors {
            top: parent.top
            topMargin: Theme.dp(18)
            left: parent.left
            leftMargin: Theme.dp(18)
        }

        width: Theme.iconSizeSmallPlus
        height: width
        source: "image://theme/icon-splus-critical-importance"
    }

    Label {
        id: mainLabel

        anchors {
            top: parent.top
            topMargin: Theme.dp(18)
            left: icon.right
            leftMargin: Theme.paddingMedium
            right: parent.right
            rightMargin: Theme.dp(18)
        }

        //% "Changes will not be saved!"
        text: qsTrId("settings_users-la-login_restriction_will-not-be-saved") + "\n" + root.text
        color: Theme.highlightColor
        wrapMode: Text.WordWrap
        font.pixelSize: Theme.fontSizeSmall
        font.family: "ALS Hauss Variable"
    }
}
