/**
 * SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: MIT
 */

import QtQuick 2.0
import ru.omp.auth.lockout 1.0

Item {
    property int uid
    property bool userLocked

    function resultMessage(id) {
        userLocked = true

        switch (id) {
        case SettingsLockout.NoLockout:
            userLocked = false
            //% "No Lockout"
            return qsTrId("auth-lockout-er-no-lockout")
        case SettingsLockout.LockoutWithTimer:
        case SettingsLockout.LockoutWithoutTimer:
            //% "Device is not available for use"
            return qsTrId("auth-lockout-er-recoverable")
        case SettingsLockout.PermanentLockout:
            //% "Device is permanently locked"
            return qsTrId("auth-lockout-er-permanent")
        default:
            //% "Other error"
            return qsTrId("auth-lockout-er-other-error")
        }
    }

    function errorMessage(id) {
        return lockoutSettings.warning
    }

    SettingsLockout {
        id: lockoutSettings
    }
}
