/****************************************************************************
**
** SPDX-FileCopyrightText: 2015 Jolla Ltd.
** SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.1
import Sailfish.Silica 1.0

FocusScope {
    property bool destroyWhenHidden

    width: parent.width
    height: parent.height
    enabled: opacity === 1.0
    opacity: 0.0
    onOpacityChanged: {
        if (opacity === 0.0 && destroyWhenHidden) {
            destroy()
        }
    }

    Behavior on opacity { FadeAnimation {} }
}
