/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Rectangle {
    id: root

    property bool active
    property alias symbol: textField.text

    anchors.horizontalCenter: parent.horizontalCenter
    width: parent.width - Theme.dp(8)
    height: width
    radius: width * 0.5
    color: active ? Theme.highlightColor : "transparent"

    Text {
        id: textField

        function isLowSymbol() {
            const lowSymbols = ["g", "j", "y", "q", "p"]
            for (var i = 0; i < lowSymbols.length; i++) {
                if (lowSymbols[i] === symbol) {
                    return true
                }
            }
            return false
        }

        anchors {
            horizontalCenter: parent.horizontalCenter
            bottom: parent.bottom
            bottomMargin: (parent.height - height) * 0.5 + (textField.isLowSymbol() ? Theme.dp(5) : 0)
        }

        width: Theme.dp(20)
        height: width
        verticalAlignment: Text.AlignVCenter
        horizontalAlignment: Text.AlignHCenter
        lineHeight: 1.25
        color: root.active ?  Theme.darkPrimaryColor : Theme.primaryColor
        font.pixelSize: Theme.fontSizeExtraLarge
    }
}
