/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Column {
    id: root

    property var passwordPolicies
    property bool isSmallSize
    property int policyWidth

    spacing: Theme.paddingMedium

    Repeater {
        model: passwordPolicies ? passwordPolicies : 0

        Row {
            width: policyWidth
            spacing: Theme.paddingMedium
            visible: isCorrectIndex(model.index)

            Item {
                id: switcher

                anchors.top: parent.top
                width: isSmallSize ? Theme.iconSizeExtraSmall : Theme.iconSizeSmall
                height: width

                Icon {
                    anchors.fill: parent
                    source: "../icons/m-icon-accept.svg"
                    visible: model.accepted
                    color: model.accepted ? Theme.highlightColor : Theme.primaryColor
                }

                Rectangle {
                    anchors.fill: parent
                    visible: !model.accepted
                    color: "transparent"
                    radius: width * 0.5

                    border {
                        color: Theme.rgba(Theme.primaryColor, 0.4)
                        width: 3
                    }
                }
            }

            Text {
                anchors.verticalCenter: parent.verticalCenter
                width: parent.width - Theme.paddingMedium - switcher.width
                wrapMode: Text.Wrap
                text: model.name
                color: model.accepted ? Theme.highlightColor : Theme.primaryColor
                font.pixelSize: isSmallSize ? Theme.fontSizeExtraSmall : Theme.fontSizeMedium
            }
        }
    }
}
