/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

BackgroundItem {
    id: root

    property bool isLandscape
    property bool defaultActive
    property bool isTablet: Screen._isTablet
    property int sizeCategory: Screen.sizeCategory
    property int maxWidth: Theme.itemSizeHuge
    property int contentWidth: width
    property alias iconSource: image.source
    readonly property int padding: isTablet ? Theme.paddingLarge : 0

    // These colors are taken from the ui-jolla-keyboard package
    readonly property color baseColor: Theme.highlightColor
    readonly property bool isLightScheme: Theme.colorScheme === Theme.DarkOnLight
    readonly property real baseColorHue: rgbToHue(baseColor.r, baseColor.g, baseColor.b)
    readonly property color actionPressedColor: isLightScheme
                                                ? Qt.hsla(baseColorHue, 0.7, 0.6, 1)
                                                : Qt.hsla(baseColorHue, 0.55, 0.55, 1)
    readonly property color actionInitialColor: isLightScheme
                                                ? Qt.hsla(baseColorHue, 0.7, 0.5, 1)
                                                : Qt.hsla(baseColorHue, 0.55, 0.45, 1)
    readonly property color modifierInitialColor: Theme.rgba(Theme.primaryColor, 0.2)

    function rgbToHue(r, g, b) {
        const max = Math.max(r, g, b)
        const min = Math.min(r, g, b);
        if (max === min) {
            return 0
        }
        const d = max - min;
        var h = 0;
        switch(max) {
            case r: h = (g - b) / d + (g < b ? 6 : 0); break;
            case g: h = (b - r) / d + 2; break;
            case b: h = (r - g) / d + 4; break;
        }
        return h /= 6;
    }

    anchors.bottom: parent.bottom
    width: Math.min(maxWidth, isTablet
                              ? sizeCategory === Screen.ExtraLarge
                                ? Theme.itemSizeHuge
                                : isLandscape ? Theme.dp(146) : Theme.itemSizeLarge
                              : Theme.dp(68))
    height: sizeCategory === Screen.ExtraLarge
            ? Theme.itemSizeMedium
            : isTablet ? Theme.dp(80) : Math.min(Theme.dp(68), width)
    highlightedColor: "transparent"
    opacity: enabled ? 1.0 : Theme.opacityHigh
    hoverEnabled: visible
    cursorShape: enabled ? Qt.PointingHandCursor : Qt.ForbiddenCursor

    Rectangle {
        anchors.left: parent.left
        width: contentWidth
        height: parent.height
        radius: Math.min(width, height) * 0.5
        color: root.down
               ? actionPressedColor
               : defaultActive && root.enabled ? actionInitialColor : modifierInitialColor

        Icon {
            id: image

            anchors.centerIn: parent
            color: Theme.lightPrimaryColor
        }
    }
}
