/*
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import QtGraphicalEffects 1.0
import Sailfish.Silica 1.0
import org.nemomobile.systemsettings 1.0
import Sailfish.Contacts 1.0

Rectangle {
    property var user
    property bool highlighted

    function abbreviation(name) {
        var arrayOfStrings = name.split(" ")
        var abb = ""

        for (var i = 0; i < arrayOfStrings.length; i++) {
            abb += arrayOfStrings[i].substring(0, 1)
        }

        return abb.toUpperCase().substring(0, 2)
    }

    height: width
    color: Theme.rgba(Theme.primaryColor, Theme.opacityFaint)
    radius: width * 0.5

    Label {
        anchors.centerIn: parent
        text: user ? abbreviation(user.displayName) : ""
        visible: !userAvatar.visible
        color: highlighted ? Theme.highlightColor : Theme.primaryColor
        font.pixelSize: Theme.fontSizeExtraLarge
    }

    RoundedItem {
        id: userAvatar

        anchors.fill: parent
        visible: user ? user.avatarPath.length !== 0 : false
        roundedCorners: visible

        Image {
            id: img

            anchors.fill: parent
            source: user ? user.avatarPath : ""
            fillMode: Image.PreserveAspectFit
        }

        Rectangle {
            anchors.fill: img
            color: Theme.highlightColor
            opacity: highlighted ? 0.6 : 0.0
        }
    }
}
