/****************************************************************************
**
** Copyright (c) 2023. Open Mobile Platform LLC.
** Copyright (c) 2019. Jolla Ltd.
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import ru.omp.authclient 1.0

PasswordField {
    property bool requireAuthentication
    property string authenticationPrompt

    _automaticEchoModeToggle: false

    on_EchoModeToggleClicked: {
        if (_usePasswordEchoMode) {
            if (requireAuthentication) {
                authQuery.authenticate( function () {
                    _usePasswordEchoMode = false
                    requireAuthentication = false
                })
            } else {
                _usePasswordEchoMode = false
            }
        } else {
            _usePasswordEchoMode = true
        }
    }

    onTextChanged: if (!activeFocus && text.length > 0) requireAuthentication = true

    Connections {
        target: Qt.application
        onActiveChanged: if (!Qt.application.active && text.length > 0) requireAuthentication = true
    }

    AuthQuery {
        id: authQuery
    }
}
