/*
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import QtQuick.Layouts 1.1
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Dialog {
    id: root

    property bool isOsTainted: true

    canAccept: true
    acceptDestination: Dialog {}

    DialogHeader {
        id: header

        acceptText: root.isOsTainted
            //% "Substitute and reboot"
            ? qsTrId("settings_substitution-substitute-and-reboot")
            //% "Substitute and reset"
            : qsTrId("settings_substitution-substitute-and-reset")
        cancelText: ""
    }

    SilicaFlickable {
        anchors {
            top: header.bottom
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }

        Column {
            x: Theme.horizontalPageMargin
            width: parent.width - 2 * x
            spacing: Theme.paddingLarge

            Column {
                width: parent.width
                spacing: Theme.paddingMedium

                Label {
                    wrapMode: Text.Wrap
                    color: Theme.highlightColor
                    //% "Disclaimer"
                    text: qsTrId("settings_substitution-disclaimer")
                    font.pixelSize: Theme.fontSizeExtraLarge
                }

                Label {
                    color: Theme.highlightColor
                    opacity: 0.8
                    wrapMode: Text.Wrap
                    //% "About LGPLv3 components substitution"
                    text: qsTrId("settings_substitution-about-substituted-lgplv3-components")
                    font.pixelSize: Theme.fontSizeMedium
                }
            }

            Label {
                width: parent.width
                color: Theme.primaryColor
                wrapMode: Text.Wrap
                //% "You are initiating substitution of one or more operating system components "
                //% "distributed under the GNU Lesser General Public License, version 3 (LGPLv3)."
                text: qsTrId("settings_substitution-you-are-initializing-substitution")
                font.pixelSize: Theme.fontSizeSmall
            }

            Column {
                width: parent.width
                spacing: Theme.paddingMedium

                Label {
                    color: Theme.highlightColor
                    opacity: 0.8
                    //% "Important:"
                    text: qsTrId("settings_substitution-important")
                    font.pixelSize: Theme.fontSizeSmall
                }

                Column {
                    width: parent.width

                    Repeater {
                        model: ListModel {
                            //% "The components to be substituted are listed in the documentation for this OS build."
                            ListElement { item: qsTrId("settings_substitution-components-allowed-for") }
                            //% "The substitution is performed using a system mechanism that does not require manual "
                            //% "intervention. It will initiate a factory reset."
                            ListElement { item: qsTrId("settings_substitution-substitution-will-reset-device") }
                            //% "During the reset process, all user data and settings will be deleted. "
                            //% "It is not guaranteed the system be restored to its normal state."
                            ListElement { item: qsTrId("settings_substitution-user-data-will-be-deleted-reboot-is-not-guaranteed") }
                        }

                        RowLayout {
                            width: parent.width
                            spacing: Theme.paddingSmall

                            Label {
                                anchors.top: parent.top
                                horizontalAlignment: Text.AlignRight
                                text: "%1.".arg(index + 1)
                                font.pixelSize: Theme.fontSizeSmall
                                Layout.minimumWidth: Theme.fontSizeSmall
                            }

                            Label {
                                wrapMode: Text.Wrap
                                text: modelData
                                font.pixelSize: Theme.fontSizeSmall
                                Layout.fillWidth: true
                            }
                        }
                    }
                }
            }

            Column {
                width: parent.width
                spacing: Theme.paddingMedium

                Label {
                    color: Theme.highlightColor
                    opacity: 0.8
                    //% "Responsibility:"
                    text: qsTrId("settings_substitution-responsibility")
                    font.pixelSize: Theme.fontSizeSmall
                }

                Column {
                    width: parent.width

                    Repeater {
                        model: ListModel {
                            //% "All actions are performed under the full responsibility of the user."
                            ListElement { item: qsTrId("settings_substitution-actions-are-users-responsibility") }
                            //% "OS developers are not responsible for the consequences caused by the component substitution, "
                            //% "including, but not limited to: malfunction, data loss, or compatibility with third-party software."
                            ListElement { item: qsTrId("settings_substitution-os-developers-are-not-responsible-for-damage") }
                        }

                        RowLayout {
                            width: parent.width
                            spacing: Theme.paddingSmall

                            Label {
                                anchors.top: parent.top
                                horizontalAlignment: Text.AlignRight
                                text: "%1.".arg(index + 1)
                                font.pixelSize: Theme.fontSizeSmall
                                Layout.minimumWidth: Theme.fontSizeSmall
                            }

                            Label {
                                wrapMode: Text.Wrap
                                text: modelData
                                font.pixelSize: Theme.fontSizeSmall
                                Layout.fillWidth: true
                            }
                        }
                    }
                }
            }

            Label {
                width: parent.width
                color: Theme.primaryColor
                wrapMode: Text.Wrap
                //% "By initiating the substitution you agree to the above terms and conditions "
                //% "and confirm your understanding of all risks."
                text: qsTrId("settings_substitution-you-agree-with-risks")
                font.pixelSize: Theme.fontSizeSmall
            }
        }
    }
}
