/**
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */
 
import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Telephony 1.0
import Sailfish.Policy 1.0
import MeeGo.QOfono 0.2
import MeeGo.Connman 0.2
import Nemo.DBus 2.0
import org.nemomobile.ofono 1.0

ViewPlaceholder {
    id: root

    property var multiSimManager

    property string modemPath: Telephony.multiSimSupported || modemManager.availableModems.length === 0
                               ? ""
                               : modemManager.availableModems[0]
    property NetworkManagerFactory networkManagerFactory: NetworkManagerFactory {}
    property OfonoModemManager modemManager: OfonoModemManager {}
    property OfonoSimManager simManager: OfonoSimManager { modemPath: root.modemPath }

    property bool isFlightMode: root.networkManagerFactory.instance.offlineMode
    property bool showSimActivation: root.modemManager.availableModems.length <= 1
                                     && (root.simManager.pinRequired === OfonoSimManager.SimPin
                                         || root.simManager.pinRequired === OfonoSimManager.SimPuk)

    property QtObject _pinQuery: DBusInterface {
        service: "com.jolla.PinQuery"
        path: "/com/jolla/PinQuery"
        iface: "com.jolla.PinQuery"
    }

    enabled: text.length > 0

    text: {
        if (isFlightMode) {
            //% "Not available in flight mode"
            return qsTrId("settings_system-he-not_available_in_flight_mode")
        }
        if (root.modemManager && root.modemManager.availableModems.length <= 1) {
            if (showSimActivation) {
                //: Indicates a SIM is locked (pin/puk not entered)
                //% "SIM is locked"
                return qsTrId("settings_system-he-sim_locked")
            } else if (root.modemPath.length > 0 && !root.simManager.present) {
                //% "No SIM card inserted"
                return qsTrId("settings_system-he-no_sim")
            }
        }
        return ""
    }

    Button {
        onClicked: root.networkManagerFactory.instance.offlineMode = false

        anchors {
            horizontalCenter: parent.horizontalCenter
            top: parent.bottom
            topMargin: Theme.paddingLarge * 1.5 // 36dp
        }

        width: Theme.buttonWidthLarge
        //% "Turn off flight mode"
        text: qsTrId("settings_system-me-flight_mode_off")
        visible: isFlightMode && AccessPolicy.flightModeToggleEnabled
    }

    Button {
        onClicked: _pinQuery.call("requestSimPin", [])

        anchors {
            horizontalCenter: parent.horizontalCenter
            top: parent.bottom
            topMargin: Theme.paddingLarge * 1.5 // 36dp
        }
        //% "Unlock SIM card"
        text: qsTrId("settings_system-me-unlock_sim_card")
        visible: showSimActivation
    }
}
