import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root
    width: parent.width
    implicitHeight: label.height + 2*Theme.paddingSmall

    property alias color: label.color
    property alias text: label.text

    Label {
        id: label
        anchors {
            left: parent.left
            right: parent.right
            verticalCenter: parent.verticalCenter
            leftMargin: Theme.horizontalPageMargin
            rightMargin: Theme.horizontalPageMargin
        }
        color: Theme.secondaryHighlightColor
        font.pixelSize: Theme.fontSizeSmall
        wrapMode: Text.WordWrap
    }
}
