/*
 * SPDX-FileCopyrightText: 2020-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import com.jolla.settings.system 1.0

Page {
    highContrast: true

    AppBar {
        id: appBar

        //% "Installed packages"
        headerText: qsTrId("settings_package_licenses-installed-packages")
    }

    BusyIndicator {
         size: BusyIndicatorSize.Large
         anchors.centerIn: parent
         running: !packageModel.modelLoaded
    }

    SilicaListView {
        anchors {
            top: appBar.bottom
            topMargin: Theme.paddingMedium
            left: parent.left
            right: parent.right
            bottom: parent.bottom
        }

        model: packageModel
        currentIndex: -1 // otherwise currentItem will steal focus
        clip: true

        header: SubstitutorSection {
            bottomPadding: Theme.dp(32)
        }

        footer: Item {
            height: Theme.paddingMedium
        }

        delegate: BackgroundItem {
            height: Math.max(Theme.itemSizeSmall, nameLabel.height + licenseLabel.height + Theme.paddingMedium)

            Label {
                id: nameLabel
                x: Theme.horizontalPageMargin
                width: parent.width - 2 * x
                color: highlighted ? Theme.highlightColor : Theme.primaryColor
                truncationMode: TruncationMode.Fade
                text: name
                textFormat: Text.StyledText
            }

            Label {
                id: licenseLabel
                anchors {
                    top: nameLabel.bottom
                    left: nameLabel.left
                }
                width: nameLabel.width
                color: highlighted ? Theme.secondaryHighlightColor : Theme.secondaryColor
                font.pixelSize: Theme.fontSizeSmall
                truncationMode: TruncationMode.Fade
                text: license
                textFormat: Text.StyledText
            }

            onClicked: {
                pageStack.animatorPush(Qt.resolvedUrl("PackageDetailsPage.qml"), {
                    title: name,
                    version: version,
                    description: description,
                    license: license,
                    licenseText: licenseText,
                    files: files
                })
            }
        }

        VerticalScrollDecorator {}
    }

    PackageModel {
        id: packageModel

        property bool modelLoaded
        onModelReset: modelLoaded = true
    }
}
