/**
* SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
* SPDX-License-Identifier: Proprietary
*/

import QtQuick 2.6
import Sailfish.Silica 1.0

Rectangle {
    id: root
    // Settings opacity will affect all children, so set it by such approach
    color: Theme.rgba(Theme.highlightColor, 0.1)
    radius: Theme.paddingMedium

    property real horizontalMargin: Theme.paddingMedium
    property real topPadding: Theme.paddingMedium
    property real bottomPadding: Theme.paddingLarge
    property real horizontalPadding: Theme.paddingLarge
    property alias spacing: column.spacing

    // All children will be placed as a column's children
    default property alias content: column.children

    width: parent.width - 2 * horizontalMargin
    height: column.implicitHeight + topPadding + bottomPadding

    anchors.horizontalCenter: parent.horizontalCenter
    clip: true

    Column {
        id: column

        anchors {
            top: parent.top
            topMargin: root.topPadding
            horizontalCenter: root.horizontalCenter
        }

        width: root.width - root.horizontalPadding * 2
        height: implicitHeight
        spacing: Theme.paddingLarge
    }
}
