/**
 * SPDX-FileCopyrightText: 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Rectangle {
    id: root

    property bool isTablet: Screen._isTablet

    anchors.horizontalCenter: parent.horizontalCenter
    color: "transparent"
    radius: isTablet ? 72 : 48

    Rectangle {
        anchors.fill: parent
        radius: parent.radius
        opacity: 0.06
        color: Theme.highlightDimmerColor
    }

    Rectangle {
        anchors.fill: parent
        radius: parent.radius
        opacity: 0.02
        color: Theme.primaryColor
    }

    Rectangle {
        anchors.fill: parent
        radius: parent.radius
        opacity: 0.04
        color: Theme.highlightColor
    }
}
