/*
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Label {
    property bool showPointingHandCursor

    width: parent.width
    wrapMode: Text.Wrap
    textFormat: Text.StyledText
    color: Theme.primaryColor
    font.pixelSize: Theme.fontSizeExtraSmall
    linkColor: Theme.highlightColor

    onLinkActivated: {
        Qt.openUrlExternally(link)
    }

    MouseArea {
        anchors.fill: parent
        z: parent.z + 1
        propagateComposedEvents: true
        cursorShape: showPointingHandCursor ? Qt.PointingHandCursor : Qt.ArrowCursor
    }
}
