/**
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Controls 1.0
import Sailfish.Gallery 1.0

AppBar {
    id: root

    property alias settingsButton: settingsButton
    property Component advancedSettingsDialog
    property bool allowCredentialsUpdate: true
    property bool allowSync: true
    property bool allowDelete: true
    property bool allowDeleteLimited: true

    signal credentialsUpdateRequested
    signal accountDeletionRequested
    signal syncRequested

    anchors.top: parent.top
    //% "Web calendar"
    headerText: qsTrId("accounts-settings-lb-webcal")

    AppBarSpacer { }

    AppBarButton {
        id: settingsButton

        visible: false
        icon.source: "image://theme/icon-splus-setting"
    }

    AppBarButton {
        icon.source: "image://theme/icon-splus-more"

        onClicked: appBarPopup.open()

        PopupMenu {
            id: appBarPopup

            PopupMenuItem {
                //% "Update log-in details"
                text: qsTrId("accounts-me-update_credentials")
                visible: root.allowCredentialsUpdate

                onClicked: credentialsUpdateRequested()
            }

            PopupMenuItem {
                //% "Delete account"
                text: qsTrId("accounts-me-delete_account")
                visible: root.allowDelete && root.allowDeleteLimited

                onClicked: accountDeletionRequested()
            }

            PopupMenuItem {
                //% "Sync"
                text: qsTrId("accounts-me-sync")
                visible: root.allowSync

                onClicked: syncRequested()
            }

            // TODO: will be left or removed in OS-32416 
            PopupMenuItem {
                //% "Advanced settings"
                text: qsTrId("components_accounts-la-advanced_settings")
                visible: false

                onClicked: pageStack.animatorPush(advancedSettingsDialog, { "title": text })
            }
        }
    }
}
