/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

Column {
    id: root

    property alias signatureEnabled: signatureEnabledSwitch.checked
    property alias signatureText: signatureField.text

    signal signatureTextAltered
    signal requestSync

    width: parent.width

    TextSwitch {
        id: signatureEnabledSwitch

        checked: true
        //: Include signature in emails
        //% "Include signature"
        text: qsTrId("settings-accounts-la-include_email_signature")

        onCheckedChanged: root.requestSync()
    }

    SignatureField {
        id: signatureField

        onRequestSync: root.requestSync()
        onTextChanged: root.signatureTextAltered()
    }
}
