/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.6
import Sailfish.Silica 1.0

TextArea {
    id: root

    signal requestSync

    width: parent.width
    textLeftMargin: Theme.itemSizeExtraSmall
    //: Placeholder text for signature text area
    //% "Write signature here"
    placeholderText: qsTrId("settings-accounts-ph-email_signature")

    text: {
        if (settingsConf.default_signature_translation_id
            && settingsConf.default_signature_translation_catalog) {
            var translated = Format.trId(settingsConf.default_signature_translation_id,
                                         settingsConf.default_signature_translation_catalog)

            if (translated && translated !== settingsConf.default_signature_translation_id) {
                return translated
            }
        }

        //: Default signature. %1 is an operating system name without the OS suffix
        //% "Sent from my %1 device"
        return qsTrId("settings_email-la-email_default_signature").arg(aboutSettings.localizedOperatingSystemName)
    }

    onFocusChanged: if (!focus) { root.requestSync() }
}
