/*
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Aurora.Controls 1.0
import Sailfish.Silica 1.0
import Sailfish.Accounts 1.0

Page {
    id: root
    objectName: "newAccountPage"

    property var accountCreationManager

    backNavigation: false

    SilicaFlickable {
        anchors.fill: parent
        contentHeight: accountPickerHeader.height + accountPicker.height + Theme.paddingLarge

        AppBar {
            id: accountPickerHeader

            //% "Add account"
            headerText: qsTrId("settings-accounts-la-add_account")
        }

        AccountProviderPicker {
            id: accountPicker

            anchors {
                left: parent.left
                right: parent.right
                top: accountPickerHeader.bottom
            }
            
            excludeProvidersForUncreatableAccounts: true
            serviceFilter: accountCreationManager.serviceFilter
            providerFilter: accountCreationManager.providerFilter

            onProviderSelected: root.accountCreationManager.startAccountCreationForProvider(providerName, {})
        }

        VerticalScrollDecorator {}
    }
}
