/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2020-2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import com.jolla.settings 1.0

Item {
    id: root

    property alias icon: icon.source
    property string accountName
    property string userName

    anchors {
        left: parent.left
        leftMargin: SettingsUtils.isSettingsApplication ? 0 : Theme.horizontalPageMargin
        right: parent.right
        rightMargin: SettingsUtils.isSettingsApplication ? 0 : Theme.horizontalPageMargin
    }
    height: visible
            ? (SettingsUtils.isSettingsApplication
               ? header.height
               : icon.height + Theme.paddingLarge)
            : 0

    Image {
        id: icon

        anchors.top: parent.top
        width: Theme.iconSizeLarge
        height: width
        visible: !SettingsUtils.isSettingsApplication
    }

    Column {
        anchors {
            left: icon.right
            leftMargin: Theme.paddingLarge
            right: parent.right
            verticalCenter: icon.verticalCenter
        }
        visible: !SettingsUtils.isSettingsApplication

        Label {
            width: parent.width
            visible: text !== ""
            text: root.accountName
            color: Theme.highlightColor
            truncationMode: TruncationMode.Fade
            font.pixelSize: Theme.fontSizeLarge
        }
        Label {
            width: parent.width
            visible: text !== ""
            text: root.userName
            truncationMode: TruncationMode.Fade
            font.pixelSize: Theme.fontSizeSmall
            color: Theme.secondaryHighlightColor
        }
    }

    PageHeader {
        id: header

        visible: SettingsUtils.isSettingsApplication
        title: accountName
        description: userName
    }
}
