/****************************************************************************************
**
** SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0

Dialog {
    id: root

    property string accountType
    property var accountCreationManager
    property string acceptDestinationObjectName
    property bool noAccountCreationFlowAfterDeletion

    acceptDestination: noAccountCreationFlowAfterDeletion ? busyPage : newAccountPage

    onAccepted: accountCreationManager.newCreationPageNeeded = false

    AppBar {
        id: appbar

        AppBarButton {
            //% "Cancel"
            text: qsTrId("accounts-la-cancel")

            onClicked: root.reject()
        }

        AppBarSpacer {}

        AppBarButton {
            //% "Remove"
            text: qsTrId("accounts-la-remove")

            onClicked: root.accept()
        }
    }

    Label {
        anchors {
            top: parent.top
            topMargin: appbar.height + Theme.paddingLarge
            left: parent.left
            leftMargin: Theme.horizontalPageMargin
        }

        width: parent.width - Theme.horizontalPageMargin * 2
        //% "Do you really want to remove account?"
        text: qsTrId("accounts-la-remove_account")
        wrapMode: Text.Wrap
        font.pixelSize: Theme.fontSizeHuge

        Label {
            anchors {
                top: parent.bottom
                left: parent.left
            }

            width: parent.width
            //% "Account %1 will be removed"
            text: qsTrId("accounts-la-info_remove_account").arg(accountType)
            wrapMode: Text.Wrap
        }
    }
    
    Component {
        id: newAccountPage

        NewAccountPage {
            accountCreationManager: root.accountCreationManager
            Component.onCompleted: root.acceptDestinationObjectName = objectName
        }
    }

    Component {
        id: busyPage

        AccountBusyPage {
            state: "info"
            infoHeading: accountRemovalHeadingText
            infoDescription: accountRemovalDescription
            busyDescription: removingAccountText

            onStatusChanged: if (status === PageStatus.Activating) state = "busy"
        }
    }
}
