/*
 * SPDX-FileCopyrightText: Copyright 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 *
 * SPDX-License-Identifier: Proprietary
 */

var isSettingsApplication = typeof _settingsApplication !== "undefined"

function isMultiPanelMode() {
    return isSettingsApplication ? _multiPanel : false
}

function visiblePanelCount() {
    return isSettingsApplication ? splitView._visiblePanels : 0
}

function openPage(url, properties, action) {
    if (properties === undefined) {
        properties = {}
    }

    if (action === undefined) {
        action = PageStackAction.Animated
    }

    if (isSettingsApplication) {
        if (!_multiPanel && splitView.count === 1) {
            secondPanelPageStack.clear()
            secondPanelPageStack._animatorPushAsync(url, properties, action)
            splitView.push(secondPanelPageStack, {}, 4)
        } else {
            secondPanelPageStack.animatorReplaceAbove(null, url, properties || {}, action)
        }
    } else {
        pageStack.animatorPush(url, properties, action)
    }
}

function openDialogPage(url, properties, action, animator) {
    if (properties === undefined) {
        properties = {}
    }

    if (animator === undefined) {
        animator = true
    }

    if (isSettingsApplication) {
        if (dialogPageStack.parent !== splitView) {
            if (action === undefined) {
                splitView.push(dialogPageStack, {}, 4)
            } else {
                splitView.push(dialogPageStack, {}, 4, action)
            }
        }

        return animator ? dialogPageStack.animatorPush(url, properties)
                        : dialogPageStack.push(url, properties)
    } else {
        return animator ? pageStack.animatorPush(url, properties)
                        : pageStack.push(url, properties)
    }
}
