/*
 * SPDX-FileCopyrightText: 2023-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import com.jolla.settings 1.0

Item {
    id: root

    property real labelScale: 1.0
    property color labelColor
    property alias topLabelText: topLabel.text
    property alias bottomLabelText: bottomLabel.text
    property alias bottomLabelSecondText: bottomLabelSecond.text

    Column {
        anchors.verticalCenter: parent.verticalCenter
        width: root.width + (root.width * (1 - root.labelScale) * 0.8) - Theme.paddingSmall * 1.2 * root.labelScale
        transform: Scale { origin.x: 0; origin.y: parent.height * 0.5; xScale: root.labelScale; yScale: xScale }
        spacing: Theme.dp(2)

        Label {
            id: topLabel

            width: parent.width
            color: root.labelColor
            truncationMode: TruncationMode.Fade
            font.pixelSize: Theme.fontSizeSmall
        }

        Item {
            width: parent.width
            height: bottomLabel.contentHeight

            Label {
                id: bottomLabel

                anchors {
                    left: parent.left
                    right: root.bottomLabelSecondText.length ? bottomLabelSecond.left : parent.right
                    rightMargin: root.bottomLabelSecondText.length ? Theme.dp(2) : 0
                }

                height: parent.height
                color: root.labelColor
                opacity: Theme.opacityHigh
                truncationMode: TruncationMode.Fade
                font.pixelSize: Theme.fontSizeTiny
            }

            Label {
                id: bottomLabelSecond

                anchors.right: parent.right
                height: parent.height
                color: root.labelColor
                opacity: Theme.opacityHigh
                font.pixelSize: Theme.fontSizeTiny
            }
        }
    }
}
