/*
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0
import com.jolla.settings 1.0
import Aurora.Controls 1.0

TabItem {
    property var settingsObject
    readonly property string type: settingsObject ? settingsObject.type : ""

    function showCurrentPage(action) {
        if (loader.item && typeof loader.item.showCurrentPage == 'function') {
            loader.item.showCurrentPage(action)
        }
    }

    function showPage(section, path, pageStackAction, properties) {
        if (SettingsUtils.isSettingsApplication && path === "") {
            if (_multiPanel) {
                if (splitView.count > 2) {
                    splitView.pop(splitView.get(1), SplitView.Immediate)
                }
            }

            if (splitView.count > 1) {
                splitView.pop(splitView.get(0), SplitView.Immediate)
            }
        }

        if (loader.item && typeof loader.item.showPage == 'function') {
            loader.item.showPage(section, path, pageStackAction, properties || {})
        }
    }

    Loader {
        id: loader

        anchors.fill: parent
        sourceComponent: type === "section" ? sectionComponent : null
        source: {
            if (type === "view") {
                var params = settingsObject.data()["params"]
                if (params && params.source) {
                    return params.source
                }
            }
            return  ""
        }

        Component {
            id: sectionComponent
            SettingsListView {
                name: settingsObject.title
                entryPath: settingsObject.location().join("/")
            }
        }
    }
}
