/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import com.jolla.settings 1.0
import org.nemomobile.configuration 1.0

Column {
    id: root

    property string name
    property string entryPath
    property int depth: 1

    spacing: Theme.paddingSmall

    SectionHeader {
        visible: settingsModel.count > 0
        text: name
    }

    Repeater {
        id: repeater

        model: SettingsModel {
            id: settingsModel
            path: root.entryPath.split("/")
            depth: root.depth
        }

        delegate: SettingComponentLoader {
            width: parent.width
            settingsObject: model.object
        }
    }
}
