/*
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import com.jolla.settings 1.0

SilicaListView {
    id: silicaListView

    property string currentPath: "system_settings/info/about_device"

    function showCurrentPage(action) {
        var entryPath = currentPath.split("/")
        const section = entryPath[0]
        entryPath.shift()
        showPage(section, entryPath.join("/"), action)
    }

    function showPage(section, path, action, properties) {
        const array = path.split("/")
        if (array.length > 0) {
            scrollToSection(array[0])
        }

        const settingsObject = model.objectForPath(path)
        if (settingsObject) {
            const params = settingsObject.data()["params"]
            if (params && params.source) {
                SettingsUtils.openPage(params.source.toString(), properties || {}, action)
                currentPath = "%1/%2".arg(section).arg(path)
            }
        }
    }

    function scrollToSection(section) {
        for (var i = 0; i < model.count; ++i) {
            if (model.objectAt(i).name === section) {
                positionViewAtIndex(i, ListView.Beginning)
                return
            }
        }
        console.warn("scrollToSection(", section, ") - not found")
    }

    property string name
    property string entryPath
    property url iconSource
    property int depth: 1

    width: parent.width
    height: parent.height
    cacheBuffer: contentHeight

    model: SettingsModel {
        path: silicaListView.entryPath.split("/")
        depth: silicaListView.depth
    }

    delegate: SettingComponentLoader {
        settingsObject: model.object
        sectionSource: "SettingsSectionView.qml"
    }

    footer: Item {
        width: 1
        height: Theme.paddingLarge
    }

    VerticalScrollDecorator {}
}
