/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.6
import Sailfish.Silica 1.0

SilicaItem {
    id: root

    property real verticalMagrin: Theme.paddingMedium
    property real verticalPadding: Theme.paddingLarge + Theme.paddingMedium
    property real contentHeight
    default property alias content: rect.data

    anchors {
        left: parent.left
        right: parent.right
        leftMargin: Theme.horizontalPageMargin
        rightMargin: Theme.horizontalPageMargin
    }

    implicitHeight: contentHeight + (verticalPadding + verticalMagrin) * 2

    Rectangle {
        id: rect

        anchors {
            fill: parent
            topMargin: verticalMagrin
            bottomMargin: verticalMagrin
        }

        color: "transparent"
        radius: Theme.dp(24)
        border.color: Theme.rgba(palette.primaryColor, Theme.opacityFaint)
        border.width: Theme.dp(2)
    }
}
