/*
 * Copyright (c) 2023 Open Mobile Platform LLC.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import com.jolla.settings 1.0

BackgroundItem {
    id: root

    // The entry path, e.g. 'System Settings/Device/Brightness'
    property string entryPath
    property bool checked: false

    implicitHeight: Theme.itemSizeSmall

    Component.onCompleted: {
        contentItem.color = Qt.binding(function() {
            return root._showPress || root.checked
                    ? Theme.rgba(palette.highlightBackgroundColor, Theme.opacityFaint)
                    : "transparent"
        })
        contentItem.radius = Theme.paddingSmall
        contentItem.height = Theme.itemSizeSmall
        contentItem.anchors.left = Qt.binding(function() { return contentItem.parent.left })
        contentItem.anchors.right = Qt.binding(function() { return contentItem.parent.right })
        contentItem.anchors.leftMargin = Theme.horizontalPageMargin
        contentItem.anchors.rightMargin = Theme.horizontalPageMargin
        contentItem.anchors.verticalCenter = Qt.binding(function() { return contentItem.parent.verticalCenter })
    }
}
