/*
 * SPDX-FileCopyrightText: 2020-2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Sailfish.Lipstick 1.0
import Aurora.Controls 1.0

Page {
    id: page

    property alias applicationName: appBar.headerText
    property alias applicationVersion: appBar.subHeaderText
    property alias applicationIcon: appIcon.icon
    property string applicationIconMode
    property string _desktopFile
    default property alias settings: column.data

    SilicaFlickable {
        id: flickable

        anchors.fill: parent
        contentHeight: {
            if (pushUpMenu === null) {
                return contentItem.childrenRect.height + permissionsSection.height - (pullDownMenu !== null ? pullDownMenu.height : 0)
            } else {
                // PushUpMenu doesn't work with the calculation above. This calculation
                // works but then PermissionSection doesn't work with ViewPlaceholder.
                return appBar.height + permissionsSection.height
            }
        }

        LauncherIcon {
            id: appIcon

            anchors {
                left: appBar.left
                leftMargin: Theme.paddingLarge
                verticalCenter: appBar.verticalCenter
            }

            z: appBar.z + 1
            size: Theme.iconSizeMedium
            icon: page.applicationIcon
            iconMode: page.applicationIconMode
        }

        AppBar {
            id: appBar

            anchors {
                top: parent.top
                topMargin: SafeZoneRect.insets.top
            }

            // Fill iconContainer with something, so AppBar create space for proper appplication icon.
            iconContainer.textItem.text: "."
        }

        Column {
            id: column

            anchors {
                top: appBar.bottom
                left: parent.left
                right: parent.right
            }
        }

        Item {
            id: permissionsParent

            anchors.top: column.bottom
            width: parent.width
        }

        VerticalScrollDecorator {}

        Component.onCompleted: {
            if (pushUpMenu !== null) {
                // A warning related to the comment in contentHeight
                console.warn("ApplicationSettings can't currently support PushUpMenu, please consider not using it")
            }
        }
    }

    Loader {
        id: permissionsSection

        height: implicitHeight + Theme.paddingLarge
        active: _desktopFile !== ""
        // Hack to make ContextMenu work well inside this.
        // We can't parent this to flickable.contentItem as it should be
        // because that would create a binding loop but parenting to
        // nested item works just fine for this limited use case.
        parent: permissionsParent
        sourceComponent: Component {
            PermissionsSection {
                desktopFile: page._desktopFile
                width: page.width
            }
        }
    }
}
