/****************************************************************************
**
** SPDX-FileCopyrightText: 2013-2019 Jolla Ltd.
** SPDX-FileCopyrightText: 2019-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

pragma Singleton
import QtQml 2.0
import Sailfish.Silica 1.0
import Sailfish.Silica.Background 1.0
import Sailfish.Silica.private 1.0
import Sailfish.Telephony 1.0
import Nemo.FileManager 1.0
import org.nemomobile.configuration 1.0
import ru.omp.authclient 1.0
import com.jolla.lipstick 0.1

QtObject {
    property Page instance

    // SUW loads on boot, so if it has not finished, then it should be running
    property bool startupWizardRunning: startupWizardDoneWatcher.fileName !== ""

    // Bind to the device lock state which is exposed to system bus by
    // the AuthService.  Mce watches the same state so they are in sync.
    property int deviceLockState: AuthDevlockClient.state

    property bool eventsViewVisible

    property var simManager: SimManager {
        controlType: SimManagerType.Voice
    }

    // DSSS: Single active card
    // DSDS: Dual-standby
    // DADA: Dual-active
    // The SIM the user has chosen to use. Only needed by DSSS, or phase 2 implementation
    readonly property int activeSim: simManager.activeSim + 1
    // Do we want to show two separate indicators, i.e. we have DSDS or DSDA
    readonly property bool showDualSim: Telephony.multiSimSupported && simManager.ready && simManager.enabledModems.length > 1

    // Voice sim can toggled when more than one sim cards are inserted or as exception one sim card
    // inserted but it's not the active one.
    readonly property bool showMultiSimSelector: Telephony.multiSimSupported && simManager.ready
                                                 && ((Telephony.voiceSimUsageMode === Telephony.ActiveSim && simManager.simCount > 1)
                                                     || (simManager.simCount === 1 && simManager.activeSim === -1))

    property QtObject settings: ConfigurationGroup {
        path: "/desktop/lipstick-jolla-home"

        property bool side_peek_to_events: false
        property int dialog_orientation
        property bool lock_screen_camera: true
        property int security_code_notification_id
        property int blur_iterations: 2
        property int blur_kernel: Kernel.SampleSize17
        property real blur_deviation: 5
        property bool live_snapshots
        property bool lock_screen_events: false
        property bool lock_screen_events_allowed: true
    }

    property SilicaConfiguration silicaConfiguration: SilicaConfiguration { }

    property var startupWizardDoneWatcher: FileWatcher {
        onExistsChanged: if (exists) fileName = ""
    }

    function cellularContext(sim) {
        return sim === 2 ? "Cellular_1" : "Cellular"
    }

    property bool weatherAvailable
    function refreshWeatherAvailable() {
        var allowed = _hiddenAppsList.toString().indexOf("weather.desktop") < 0
        weatherAvailable = allowed ? fileUtils.exists(StandardPaths.resolveImport("Sailfish.Weather.WeatherIndicator")) : false
    }

    property FileUtils fileUtils: FileUtils { }

    property var _hiddenAppsList: HiddenApps.list

    on_HiddenAppsListChanged: refreshWeatherAvailable()

    Component.onCompleted: {
        var markerFile = StandardPaths.home + "/.omp-startupwizard-usersession-done"

        if (!startupWizardDoneWatcher.testFileExists(markerFile)) {
            startupWizardDoneWatcher.fileName = markerFile
        }

        refreshWeatherAvailable()
    }
}
