/**
 * SPDX-FileCopyrightText: 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Controls 1.0
import Sailfish.Telephony 1.0
import Aurora.Applications.Internal 1.0 as AppInternal

PopupMenu {
    id: root

    property int actionType: Telephony.Call

    signal simSelected(int sim, string modem)

    headerText: actionType === Telephony.Call
                  //% "Choose SIM for call:"
                ? qsTrId("sailfish-telephony-he-choose_sim_for_call")
                  //% "Choose SIM for answer:"
                : qsTrId("sailfish-telephony-he-choose_sim_for_answer")

    Repeater {
        model: simTelephonyManager.modemSimModel

        delegate: PopupMenuItem {
            property bool valid: !errorState.errorState

            onClicked: {
                simSelected(model.index, model.modem)
            }

            enabled: valid
            text: valid ? model.operator : errorState.shortErrorString
            icon.source: "image://theme/icon-splus-sim-%1".arg(model.index + 1)

            SimErrorState {
                id: errorState

                multiSimManager: simTelephonyManager
                modemPath: model.modem
            }
        }
    }

    SimManager {
        id: simTelephonyManager

        controlType: SimManagerType.Voice
    }

    Component.onCompleted: {
        root.preferredWidth = AppInternal.UiUtils.getPopupMenuPreferredWidth({
                                                                                 popupMenu: root,
                                                                                 maximumWidth: Screen.width - Theme.paddingLarge * 2
                                                                             })
    }
}
