/*
 * Copyright (c) 2022 - 2023 Open Mobile Platform LLC.
 * Copyright (c) 2016 - 2021 Jolla Ltd.
 *
 * License: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import org.nemomobile.systemsettings 1.0
import com.jolla.settings 1.0
import Sailfish.Settings.Networking 1.0
import Sailfish.Settings.Networking.Vpn 1.0

Dialog {
    id: root

    property Page _mainPage
    property string title
    property string failTitle
    property string message
    property string failMessage
    property bool importFailed
    property var nameFilters
    property string _vpnType

    canAccept: false
    forwardNavigation: false

    SilicaFlickable {
        anchors.fill: parent
        contentWidth: width
        contentHeight: column.height

        Column {
            id: column

            width: parent.width
            spacing: Theme.paddingLarge

            DialogHeader {
                id: pageHeader

                title: importFailed ? failTitle : root.title
                acceptText: ''
            }

            Label {
                x: Theme.horizontalPageMargin
                width: parent.width - x * 2
                text: importFailed ? failMessage : message
                textFormat: Text.StyledText
                wrapMode: Text.Wrap
                font.pixelSize: Theme.fontSizeSmall
                color: Theme.highlightColor
            }

            ButtonLayout {
                preferredWidth: Theme.buttonWidthLarge

                Button {
                    id: importButton

                    onClicked: {
                        const obj = pageStack.animatorPush("Sailfish.Pickers.FilePickerPage", {
                                                               nameFilters: root.nameFilters,
                                                               popOnSelection: false
                                                           })
                        obj.pageCompleted.connect(function(picker) {
                            picker.selectedContentPropertiesChanged.connect(function() {
                                const importer = Qt.createComponent(VpnTypes.importPath(_vpnType)).createObject()
                                const path = picker.selectedContentProperties['filePath']
                                VpnTypes.importFile(pageStack, _mainPage, path, _vpnType, importer.parseFile)
                            })
                        })
                    }

                    objectName: "importButton"
                    text: (importFailed ?
                               //% "Try again"
                               qsTrId("settings_network-bt-import_file_try_again") :
                               //% "Import file"
                               qsTrId("settings_network-bt-import_file"))
                }

                Button {
                    onClicked: pageStack.animatorReplace(VpnTypes.editDialogPath(_vpnType), {
                                                             newConnection: true,
                                                             acceptDestination: SettingsUtils.isSettingsApplication
                                                                                ? undefined
                                                                                : _mainPage,
                                                             vpnType: _vpnType
                                                         })
                    ButtonLayout.newLine: true
                    objectName: "skipImport"
                    //% "Skip"
                    text: qsTrId("settings_network-bt-skip_import")
                }
            }
        }
    }
}
