/*
 * SPDX-FileCopyrightText: 2024-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import MeeGo.Connman 0.2

Label {
    property QtObject network

    x: Theme.horizontalPageMargin
    width: parent.width - 2 * Theme.horizontalPageMargin

    //% "Encryption type is not supported"
    text: qsTrId("settings_network-la-enc_type_not_supported")
    visible: network.securityType == NetworkService.SecurityUnknown

    color: Theme.errorColor
    wrapMode: Text.Wrap
}

