/****************************************************************************
**
** SPDX-FileCopyrightText: 2013-2019 Jolla Ltd.
** SPDX-FileCopyrightText: 2019-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.0
import QtQuick.Window 2.3 as QtQuick
import Sailfish.Silica 1.0
import Sailfish.Lipstick 1.0
import org.nemomobile.lipstick 0.1
import org.nemomobile.configuration 1.0

SystemDialogWindow {
    id: dialog

    property alias layoutItem: layout
    property alias contentHeight: layout.contentHeight

    property alias allowedOrientations: window.allowedOrientations
    readonly property int orientation: window.pageStack.currentPage
            ? window.pageStack.currentPage.orientation
            : window.orientation
    readonly property alias screenHeight: window._screenHeight
    property alias backgroundVisible: window._backgroundVisible
    property alias backgroundRect: window._backgroundRect
    property bool autoDismiss: true

    property bool _closing
    default property alias _data: layout._data

    property alias __silica_applicationwindow_instance: window

    signal dismissed()
    signal closed()

    function activate() {
        _closing = false
        showFullScreen()
        raise()
    }

    function dismiss() {
        _closing = true
        lower()
        close()
        closed()
        _closing = false
    }

    width: Screen.width
    height: Screen.height

    SafeZoneRect._orientation: orientation
    SafeZoneRect._displayMode: window.displayMode
    SafeZoneRect._statusbarVisible: window._statusbarVisibleState
    SafeZoneRect._statusbarHeight: Theme.statusbarHeight

    useDialogBackground: true

    SystemDialogApplicationWindow {
        id: window

        displayMode: ApplicationDisplayMode.FillScreen
        _backgroundVisible: false
        _opaque: false
        cover: null
        allowedOrientations: lipstickSettings.dialog_orientation || QtQuick.Screen.primaryOrientation
        focus: true

        _backgroundRect: {
            switch (QtQuick.Screen.angleBetween(QtQuick.Window.window.contentOrientation, Qt.PrimaryOrientation)) {
            case 90:
                return Qt.rect(width - layout.contentLayoutHeight, 0, layout.contentLayoutHeight, height)
            case 180:
                return Qt.rect(0, height - layout.contentLayoutHeight, width, layout.contentLayoutHeight)
            case 270:
                return Qt.rect(0, 0, layout.contentLayoutHeight, height)
            case 0:
            default:
                return Qt.rect(0, 0, width, layout.contentLayoutHeight)
            }
        }
    }

    ConfigurationGroup {
        id: lipstickSettings
        path: "/desktop/lipstick-jolla-home"

        property int dialog_orientation
    }

    SystemDialogLayout {
        id: layout
        // This is declared outside of the initialPage component so its members can be aliased,
        // but parented to that page when it exists so that it receives orientation transforms
        // and transitions.
        parent: window.pageStack.currentPage ? window.pageStack.currentPage : window.contentItem

        focus: !dialog._closing

        onDismiss: {
            if (dialog.autoDismiss) {
                dialog.dismissed()
                dialog.dismiss()
            }
        }
    }
}
