/****************************************************************************
**
** SPDX-FileCopyrightText: 2013-2015 Jolla Ltd.
** SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import org.nemomobile.lipstick 0.1

FocusScope {
    id: layout

    default property alias _data: content.data

    property alias contentItem: content
    property alias contentHeight: content.height
    property real contentLayoutHeight: content.height + content.y + contentBottomMargin
    property real contentTopMargin: LipstickApi.compositor
                                    ? (LipstickApi.compositor.safeZoneRect
                                       ? LipstickApi.compositor.safeZoneRect.insets.top : 0)
                                    : SafeZoneRect.insets.top
    property real contentBottomMargin: LipstickApi.compositor
                                       ? (LipstickApi.compositor.safeZoneRect
                                          ? LipstickApi.compositor.safeZoneRect.insets.bottom : 0)
                                       : SafeZoneRect.insets.bottom
    property real contentLeftMargin: LipstickApi.compositor
                                     ? (LipstickApi.compositor.safeZoneRect
                                        ? LipstickApi.compositor.safeZoneRect.insets.left : 0)
                                     : SafeZoneRect.insets.left
    property real contentRightMargin: LipstickApi.compositor
                                      ? (LipstickApi.compositor.safeZoneRect
                                         ? LipstickApi.compositor.safeZoneRect.insets.right : 0)
                                      : SafeZoneRect.insets.right

    signal dismiss

    anchors.fill: parent

    MouseArea {
        anchors.fill: parent
        onClicked: layout.dismiss()
    }

    MouseArea {
        id: blocker

        objectName: "SystemDialogLayout_blocker"
        // block events passing beneath the layout
        anchors.fill: content
    }

    Item {
        id: content

        y: contentTopMargin
        x: contentLeftMargin

        width: parent.width - contentRightMargin - x
    }
}
