/****************************************************************************
**
** SPDX-FileCopyrightText: 2013-2015 Jolla Ltd.
** SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import org.nemomobile.lipstick 0.1

FocusScope {
    id: layout

    default property alias _data: content.data

    property alias contentItem: content
    property alias contentHeight: content.height
    property real contentLayoutHeight: content.height + content.y + contentBottomMargin
                                       + contentLayoutTopMargin

    property var safeZoneRect: LipstickApi.compositor ? LipstickApi.compositor.safeZoneRect : SafeZoneRect
    property real contentTopMargin: safeZoneRect ? safeZoneRect.insets.top : 0
    property real contentBottomMargin: safeZoneRect ? safeZoneRect.insets.bottom : 0
    property real contentLeftMargin: safeZoneRect ? safeZoneRect.insets.left : 0
    property real contentRightMargin: safeZoneRect ? safeZoneRect.insets.right : 0
    property real contentLayoutTopMargin: {
        if (safeZoneRect && contentTopMargin == 0) {
            // Take the statusbar height from SafeZoneRect when it visible
            // on devices without the cutout.
            switch (safeZoneRect._orientation) {
                case Orientation.Portrait: return safeZoneRect.appInsets.top
                case Orientation.PortraitInverted: return safeZoneRect.appInsets.bottom
                case Orientation.Landscape: return safeZoneRect.appInsets.right
                case Orientation.LandscapeInverted: return safeZoneRect.appInsets.left
            }
        }
        return 0
    }

    signal dismiss

    anchors.fill: parent

    MouseArea {
        anchors.fill: parent
        onClicked: layout.dismiss()
    }

    MouseArea {
        id: blocker

        objectName: "SystemDialogLayout_blocker"
        // block events passing beneath the layout
        anchors.fill: content
    }

    Item {
        id: content

        y: contentTopMargin
        x: contentLeftMargin

        width: parent.width - contentRightMargin - x
    }
}
