/****************************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2021-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0

// This declares an ApplicationWindow with an empty page for SystemDialog, it is not declared in
// SystemDialog as __silica_applicationwindow_instance cannot be resolved by Page if
// ApplicationWindow is not the root item.

ApplicationWindow {
    id: window

    property Page _dialogMainPage

    initialPage: Component {
        Page {
            id: page

            allowedOrientations: Orientation.All

            Component.onCompleted: window._dialogMainPage = page
            Component.onDestruction: window._dialogMainPage = null
        }
    }
}
