/****************************************************************************
**
** SPDX-FileCopyrightText: Copyright 2021-2023 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
** Copyright (c) 2013 - 2021 Jolla Ltd.
**
****************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0

SilicaGridView {
    id: grid

    property real statusBarHeight: Theme.paddingMedium + Theme.paddingSmall + Theme.iconSizeExtraSmall
    property size coverSize

    property int baseY: _largeScreen
                        ? (_pageHeight > parent.width ? statusBarHeight + Theme.paddingLarge : Theme.paddingLarge * 5)
                        : statusBarHeight

    property Item _page
    property int _pageHeight: _page ? _page.height : Screen.height
    readonly property bool _largeScreen: Screen.sizeCategory >= Screen.Large
    readonly property int _columns: _largeScreen ? 3 : 2
    readonly property int _rows: Math.ceil(count / _columns)
    readonly property real coverHeaderHeight: 2 * Math.round(Theme.dp(38))
    readonly property real spacing: Theme.dp(16)

    function itemAtIndex(index) {
        const currentIndex = grid.currentIndex
        grid.currentIndex = index
        var item = grid.currentItem
        grid.currentIndex = currentIndex
        return item;
    }

    x: Math.floor((parent.width - width) * 0.5)
    width: cellWidth * _columns
    height: cellHeight * _rows
    interactive: false
    cellHeight: coverSize.height + coverHeaderHeight + spacing
    cellWidth: coverSize.width + spacing

    Component.onCompleted: {
        var parentItem = grid.parent
        while (parentItem) {
            if (parentItem.hasOwnProperty("__silica_page")) {
                _page = parentItem
                return
            }
            parentItem = parentItem.parent
        }
    }
}
