/*
 * SPDX-FileCopyrightText: 2023-2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0

Item {
    id: root

    default property alias _data: iconParent.data
    property string label
    property int labelMargins
    property Component contentComponent
    property var properties: {}
    property int contentMargins
    property bool showFromCenter
    property bool stretchContentToPopup
    property alias highlightBorder: highlight.border
    property alias highlightOpacity: highlight.opacity
    property alias highlightColor: highlight.color
    property alias highlightRadius: highlight.radius
    property alias highlightScale: highlight.scale
    property alias _iconItem: iconParent

    signal popupDestroyed()

    function _findPopupPage() {
        var parentItem = root
        while (parentItem.parent) {
            parentItem = parentItem.parent

            if (parentItem.hasOwnProperty('__popup_page')) {
                return parentItem
            }
        }
        return null
    }

    function showPopup(force) {
        if (!contentComponent) {
            return
        }

        if (force === undefined) {
            force = false
        }

        const popupPage = _findPopupPage()

        if (popupPage) {
            popupPage._show(root, force)
        }
    }

    function hidePopup() {
        if (!contentComponent) {
            return
        }

        const popupPage = _findPopupPage()
        if (popupPage) {
            popupPage._hide()
        }
    }

    Rectangle {
        id: highlight

        anchors.fill: color != "transparent" ? parent : undefined
        color: "transparent"
        opacity: 0.0
    }

    Item {
        id: iconParent

        anchors.fill: parent
    }
}
