/****************************************************************************
**
** SPDX-FileCopyrightText: 2015-2019 Jolla Ltd.
** SPDX-FileCopyrightText: 2022-2025 Open Mobile Platform LLC <community@omp.ru>
** SPDX-License-Identifier: Proprietary
**
****************************************************************************/

import QtQuick 2.2
import Sailfish.Silica 1.0
import Sailfish.Silica.private 1.0 as Private
import Sailfish.Lipstick 1.0

FocusScope {
    id: homescreenItem

    property Item leftItem
    property Item rightItem
    property Item topItem
    property Item bottomItem

    readonly property bool isCurrentItem: Private.Slide.isCurrent
    readonly property bool exposed: Private.Slide.isExposed
    readonly property real offset: Private.Slide.offset
    readonly property real switchProgress: Private.Slide.switchProgress
    // test for 'undeined' of 'view.moving' property
    readonly property bool viewMoving: Private.Slide.view && Private.Slide.view.moving || false

    property var cleanup

    Private.Slide.backward: leftItem || topItem
    Private.Slide.forward: rightItem || bottomItem

    Private.Slide.onCleanup: {
        if (cleanup) {
            cleanup()
        }
    }
}
